/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.tristankechlo.livingthings.client.model.AdvancedEntityModel;
import com.tristankechlo.livingthings.entity.GiraffeEntity;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class GiraffeModel<T extends GiraffeEntity>
extends AdvancedEntityModel<T> {
    private final ModelPart Body;
    private final ModelPart Head;
    private final ModelPart Legs;
    private final ModelPart NeckTop;
    private final ModelPart NeckMiddle;
    private final ModelPart NeckBottom;
    private final ModelPart FrontRightLeg;
    private final ModelPart FrontLeftLeg;
    private final ModelPart BackRightLeg;
    private final ModelPart BackLeftLeg;
    private final ModelPart TailTop;
    private final ModelPart TailBottom;

    public GiraffeModel(ModelPart root) {
        this.Body = root.m_171324_("Body");
        this.Legs = this.Body.m_171324_("Legs");
        this.NeckBottom = this.Body.m_171324_("NeckBottom");
        this.NeckMiddle = this.NeckBottom.m_171324_("NeckMiddle");
        this.NeckTop = this.NeckMiddle.m_171324_("NeckTop");
        this.Head = this.NeckTop.m_171324_("Head");
        this.FrontRightLeg = this.Legs.m_171324_("FrontRightLeg");
        this.FrontLeftLeg = this.Legs.m_171324_("FrontLeftLeg");
        this.BackRightLeg = this.Legs.m_171324_("BackRightLeg");
        this.BackLeftLeg = this.Legs.m_171324_("BackLeftLeg");
        this.TailTop = this.Body.m_171324_("TailTop");
        this.TailBottom = this.TailTop.m_171324_("TailBottom");
    }

    public void m_7695_(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        if (this.f_102610_) {
            matrixStackIn.m_85841_(0.6f, 0.6f, 0.6f);
            matrixStackIn.m_252880_(0.0f, 1.0f, 0.0f);
        }
        this.Body.m_104301_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn);
    }

    public void setupAnim(GiraffeEntity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.Head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.NeckTop.f_104203_ = this.NeckMiddle.f_104203_ / 1.0f;
        this.NeckMiddle.f_104203_ = this.Head.f_104203_ / 2.0f;
        this.Head.f_104204_ = netHeadYaw / 3.75f * ((float)Math.PI / 180);
        this.NeckTop.f_104204_ = netHeadYaw / 3.75f * ((float)Math.PI / 180);
        this.NeckMiddle.f_104204_ = netHeadYaw / 3.75f * ((float)Math.PI / 180);
        this.NeckBottom.f_104204_ = netHeadYaw / 5.0f * ((float)Math.PI / 180);
        this.walk(this.FrontRightLeg, this.FrontLeftLeg, this.BackRightLeg, this.BackLeftLeg, limbSwing, limbSwingAmount);
        this.TailTop.f_104205_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.75f * limbSwingAmount;
        this.TailBottom.f_104205_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.75f * limbSwingAmount;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Body = partdefinition.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(72, 35).m_171488_(-6.0f, -21.5f, -13.6f, 12.0f, 13.0f, 16.0f, new CubeDeformation(0.0f)).m_171514_(81, 14).m_171488_(-5.5f, -19.5f, 2.4f, 11.0f, 11.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)14.5f, (float)0.6f));
        PartDefinition Legs = Body.m_171599_("Legs", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-7.5f, (float)-0.6f));
        PartDefinition FrontRightLeg = Legs.m_171599_("FrontRightLeg", CubeListBuilder.m_171558_().m_171514_(98, 0).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(116, 0).m_171488_(-1.5f, 8.0f, -1.5f, 3.0f, 10.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.0f, (float)-1.0f, (float)-10.0f));
        PartDefinition FrontLeftLeg = Legs.m_171599_("FrontLeftLeg", CubeListBuilder.m_171558_().m_171514_(98, 0).m_171480_().m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(116, 0).m_171488_(-1.5f, 8.0f, -1.5f, 3.0f, 10.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.0f, (float)-1.0f, (float)-10.0f));
        PartDefinition BackLeftLeg = Legs.m_171599_("BackLeftLeg", CubeListBuilder.m_171558_().m_171514_(70, 0).m_171480_().m_171488_(-2.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(116, 0).m_171488_(-1.5f, 10.0f, -1.5f, 3.0f, 10.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.0f, (float)-3.0f, (float)10.0f));
        PartDefinition BackRightLeg = Legs.m_171599_("BackRightLeg", CubeListBuilder.m_171558_().m_171514_(70, 0).m_171488_(-2.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(116, 0).m_171488_(-1.5f, 10.0f, -1.5f, 3.0f, 10.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.0f, (float)-3.0f, (float)10.0f));
        PartDefinition NeckBottom = Body.m_171599_("NeckBottom", CubeListBuilder.m_171558_().m_171514_(0, 46).m_171488_(-4.5f, -2.0f, -3.5f, 9.0f, 9.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-21.5f, (float)-13.6f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition NeckMiddle = NeckBottom.m_171599_("NeckMiddle", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171488_(-3.5f, -10.0f, -3.5f, 7.0f, 11.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-2.0f, (float)1.0f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition NeckTop = NeckMiddle.m_171599_("NeckTop", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.5f, -10.0f, -2.5f, 5.0f, 11.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-10.0f, (float)0.0f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition Head = NeckTop.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(41, 52).m_171488_(-3.0f, -6.0f, -4.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-8.0f, (float)0.0f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition FrontHead = Head.m_171599_("FrontHead", CubeListBuilder.m_171558_().m_171514_(46, 41).m_171488_(-2.0f, -2.0f, -4.0f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)-4.0f));
        PartDefinition Horns = Head.m_171599_("Horns", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition LeftHorn = Horns.m_171599_("LeftHorn", CubeListBuilder.m_171558_().m_171514_(30, 15).m_171488_(0.5f, -2.5f, 0.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.0f, (float)-6.0f, (float)0.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition RightHorn = Horns.m_171599_("RightHorn", CubeListBuilder.m_171558_().m_171514_(30, 15).m_171488_(-0.5f, -2.5f, 0.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.0f, (float)-6.0f, (float)0.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition Ears = Head.m_171599_("Ears", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition LeftEar = Ears.m_171599_("LeftEar", CubeListBuilder.m_171558_().m_171514_(36, 16).m_171488_(0.0f, -1.0f, 0.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)-4.0f, (float)0.0f));
        PartDefinition RightEar = Ears.m_171599_("RightEar", CubeListBuilder.m_171558_().m_171514_(36, 16).m_171488_(-1.0f, -1.0f, 0.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.0f, (float)-4.0f, (float)0.0f));
        PartDefinition TailTop = Body.m_171599_("TailTop", CubeListBuilder.m_171558_().m_171514_(48, 4).m_171488_(-1.0f, 0.0f, -0.5f, 1.0f, 9.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-16.5f, (float)12.4f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition TailBottom = TailTop.m_171599_("TailBottom", CubeListBuilder.m_171558_().m_171514_(53, 4).m_171488_(-1.0f, 0.0f, -0.5f, 1.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)9.0f, (float)0.0f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)64);
    }
}

